$(document).ready(function() 
{
	$('#server_seed').val(decodeURIComponent($.urlParam('server_seed')));
	$('#client_seed').val(decodeURIComponent($.urlParam('client_seed')));
	$('#server_seed_hash').val(decodeURIComponent($.urlParam('server_seed_hash')));
	$('#nonce').val(decodeURIComponent($.urlParam('nonce')));
	$("#verify").click(function(event) 
	{
		var server_seed = $('#server_seed').val();
		var client_seed = $('#client_seed').val();
		var nonce = $('#nonce').val();
		var server_seed_hash = CryptoJS.SHA256(server_seed).toString(CryptoJS.enc.Hex);
		var string1 = nonce.concat(":",server_seed,":",nonce);
		var string2 = nonce.concat(":",client_seed,":",nonce);
		var hmac512 = CryptoJS.HmacSHA512(string1,string2).toString(CryptoJS.enc.Hex);
		var string3 = hmac512.substring(0,8);
		var number = parseInt(string3, 16);
		var roll = (Math.round(number/429496.7295)).toFixed(0);
		$('#rolled_number').val(roll);
		if ($('#server_seed_hash').val() == server_seed_hash)
		{
			swal("Success!", "SERVER SEED HASH MATCHES", "success");
		}
		else
		{
			swal("Error!", "SERVER SEED HASH DOES NOT MATCH", "error");
		}
	});
});
$.urlParam = function(name)
{
	var results = new RegExp('[\?&]' + name + '=([^&#]*)').exec(window.location.href);
	if (results==null){
	   return '';
	}
	else{
	   return results[1] || 0;
	}
}